# -*- coding: utf-8 -*-
"""
Created on Wed Nov 11 11:17:39 2015

This is a blueprint to create 'concentrations', 'peak concentrations', etc
Concentrations are obtained from the class CCalculateConcentrations, and the
peak concentrations and others are 'derived' from the concentrations 

Note: concentrations are calculated from 'other stuff' while here 'derivations'
are done from concentrations

"""
import matplotlib.pylab as plt
import numpy as np

class CModel:

    def __init__(self):
        self.Concentrations = 0        
        return
        
    def NormalisedConcentrations(self,AYIndex):
        concentrations = self.Concentrations
        maximum = np.amax(concentrations)
        assert maximum  != 0.0
        normalised_concentrations = concentrations / maximum
        return normalised_concentrations
                        
    def PeakConcentrationsOverDistance(self,AYIndex):
        concentrations = self.Concentrations
        peak_concentrations = np.zeros(len(concentrations[:,AYIndex,0]),float)
        for x_index in np.arange(0,len(peak_concentrations)):            
            peak_concentrations[x_index] = np.amax(concentrations[x_index,AYIndex,:])
        return peak_concentrations        

    def PeakConcentrationsOverTime(self,AYIndex):
        concentrations = self.Concentrations
        peak_concentrations = np.zeros(len(concentrations[0,AYIndex,:]),float)
        for time_index in np.arange(0,len(peak_concentrations)):            
            peak_concentrations[time_index] = np.amax(concentrations[:,AYIndex,time_index])
        return peak_concentrations

    def PeakNormalisedConcentrationsOverTime(self,AYIndex):
        peak_concentrations = self.PeakConcentrationsOverTime(AYIndex)
        maximum = np.amax(peak_concentrations)
        assert maximum  != 0.0
        normalised_peak_concentrations = peak_concentrations / maximum
        return normalised_peak_concentrations
        
    def PlotConcentrationsVersusTime(self, ATimeValues, AXIndex, AYIndex, ALabel, ALineStyle):
        # BE CAREFUL! x is the INDEX not the LOCATION!
        plt.plot(ATimeValues, self.Concentrations[AXIndex,AYIndex,:],label=ALabel, linestyle=ALineStyle)

    def PlotPeakConcentrationsVersusDistance(self, ADistanceValues, AYIndex, ALabel, ALineStyle):
        peak_concentrations = self.PeakConcentrationsOverTime(AYIndex)
        plt.plot(ADistanceValues, peak_concentrations, label=ALabel, linestyle=ALineStyle)

    def PlotPeakConcentrationsVersusTime(self, ATimeValues, AYIndex, ALabel, ALineStyle):
        peak_concentrations = self.PeakConcentrationsOverDistance(AYIndex)
        plt.plot(ATimeValues, peak_concentrations, label=ALabel, linestyle=ALineStyle)

    def PlotPeakConcentrationsNormalisedVersusTime(self, ATimeValues, AYIndex, ALabel, ALineStyle):
        peak_concentrations_normalised = self.PeakNormalisedConcentrationsOverTime(AYIndex)
        plt.plot(ATimeValues, peak_concentrations_normalised, label=ALabel, linestyle=ALineStyle)        
        
    def Setup(self,ADomain,AInitialConcentration=0):
        x_length = ADomain.X.NumberOfSteps()
        y_length = ADomain.Y.NumberOfSteps()
        time_length = ADomain.Time.NumberOfSteps()
        
        self.Values = np.zeros((x_length, y_length, time_length), float)
        self.Values[:] = AInitialConcentration # change to initial conc)

    def CalculateExceedances(self, AThreshold):
        concentrations = self.Concentrations     
        count = sum(sum(sum(concentrations > AThreshold)))
        return count            
